function disableDevTools() {
    // Disable right-click context menu
    document.addEventListener("contextmenu", function(e) {
        e.preventDefault();
    }, false);

    // Disable certain keypresses
    document.onkeydown = function(e) {
        if ((e.ctrlKey && (e.keyCode === 67 || e.keyCode === 86 || e.keyCode === 85)) || // Ctrl+C, Ctrl+V, Ctrl+U
            e.keyCode === 117 || // F6
            e.keyCode === 123 || // F12
            (e.ctrlKey && e.shiftKey && (e.keyCode === 73 || e.keyCode === 74)) // Ctrl+Shift+I, Ctrl+Shift+J
        ) {
            e.preventDefault();
            return false;
        }
        return true;
    };
}

// Call the function to activate the restrictions
disableDevTools();
